# -*- buffer-read-only: t -*-
#
# This file is auto-generated by ext/Errno/Errno_pm.PL.
# ***ANY*** changes here will be lost.
#

package Errno;
require Exporter;
use strict;

use Config;
"$Config{'archname'}-$Config{'osvers'}" eq
"x86_64-sortix-current" or
	die "Errno architecture (x86_64-sortix-current) does not match executable architecture ($Config{'archname'}-$Config{'osvers'})";

our $VERSION = "1.30";
$VERSION = eval $VERSION;
our @ISA = 'Exporter';

my %err;

BEGIN {
    %err = (
	ENOTBLK => 12,
	ENODEV => 13,
	EBADF => 15,
	EOVERFLOW => 16,
	ENOENT => 17,
	ENOSPC => 18,
	EEXIST => 19,
	EROFS => 20,
	EINVAL => 21,
	ENOTDIR => 22,
	ENOMEM => 23,
	ERANGE => 24,
	EISDIR => 25,
	EPERM => 26,
	EIO => 27,
	ENOEXEC => 28,
	EACCES => 29,
	ESRCH => 30,
	ENOTTY => 31,
	ECHILD => 32,
	ENOSYS => 33,
	ENOTSUP => 34,
	EOPNOTSUPP => 34,
	EBLOCKING => 35,
	EINTR => 36,
	ENOTEMPTY => 37,
	EBUSY => 38,
	EPIPE => 39,
	EILSEQ => 40,
	ELAKE => 41,
	EMFILE => 42,
	EAGAIN => 43,
	EWOULDBLOCK => 43,
	EEOF => 44,
	EBOUND => 45,
	EINIT => 46,
	ENODRV => 47,
	E2BIG => 48,
	EFBIG => 49,
	EXDEV => 50,
	ESPIPE => 51,
	ENAMETOOLONG => 52,
	ELOOP => 53,
	EMLINK => 54,
	ENXIO => 55,
	EPROTONOSUPPORT => 56,
	EAFNOSUPPORT => 57,
	ENOTSOCK => 58,
	EADDRINUSE => 59,
	ETIMEDOUT => 60,
	ECONNREFUSED => 61,
	EDOM => 62,
	EINPROGRESS => 63,
	EALREADY => 64,
	ESHUTDOWN => 65,
	ECONNABORTED => 66,
	ECONNRESET => 67,
	EADDRNOTAVAIL => 68,
	EISCONN => 69,
	EFAULT => 70,
	EDESTADDRREQ => 71,
	EHOSTUNREACH => 72,
	EMSGSIZE => 73,
	ENETDOWN => 74,
	ENETRESET => 75,
	ENETUNREACH => 76,
	ENOBUFS => 77,
	ENOMSG => 78,
	ENOPROTOOPT => 79,
	ENOTCONN => 80,
	EDEADLK => 81,
	ENFILE => 82,
	EPROTOTYPE => 83,
	ENOLCK => 84,
	ESIGPENDING => 87,
	ESTALE => 88,
	EBADMSG => 89,
	ECANCELED => 90,
	EDQUOT => 91,
	EIDRM => 92,
	EMULTIHOP => 93,
	ENOLINK => 94,
	ENOTRECOVERABLE => 95,
	EOWNERDEAD => 96,
	EPROTO => 97,
	ETXTBSY => 98,
	ENOMOUNT => 99,
	ENOMEDIUM => 100,
	EHOSTDOWN => 101,
	ESOCKTNOSUPPORT => 102,
    );
    # Generate proxy constant subroutines for all the values.
    # Well, almost all the values. Unfortunately we can't assume that at this
    # point that our symbol table is empty, as code such as if the parser has
    # seen code such as C<exists &Errno::EINVAL>, it will have created the
    # typeglob.
    # Doing this before defining @EXPORT_OK etc means that even if a platform is
    # crazy enough to define EXPORT_OK as an error constant, everything will
    # still work, because the parser will upgrade the PCS to a real typeglob.
    # We rely on the subroutine definitions below to update the internal caches.
    # Don't use %each, as we don't want a copy of the value.
    foreach my $name (keys %err) {
        if ($Errno::{$name}) {
            # We expect this to be reached fairly rarely, so take an approach
            # which uses the least compile time effort in the common case:
            eval "sub $name() { $err{$name} }; 1" or die $@;
        } else {
            $Errno::{$name} = \$err{$name};
        }
    }
}

our @EXPORT_OK = keys %err;

our %EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPIPE EPROTONOSUPPORT EPROTOTYPE ERANGE EROFS ESHUTDOWN
	ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT ETXTBSY EWOULDBLOCK
	EXDEV
    )],
);

sub TIEHASH { bless \%err }

sub FETCH {
    my (undef, $errname) = @_;
    return "" unless exists $err{$errname};
    my $errno = $err{$errname};
    return $errno == $! ? $errno : 0;
}

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

# This is the true return value
*CLEAR = *DELETE = \*STORE; # Typeglob aliasing uses less space

sub NEXTKEY {
    each %err;
}

sub FIRSTKEY {
    my $s = scalar keys %err;	# initialize iterator
    each %err;
}

sub EXISTS {
    my (undef, $errname) = @_;
    exists $err{$errname};
}

sub _tie_it {
    tie %{$_[0]}, __PACKAGE__;
}

__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system F<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

On Windows, C<Errno> also defines and conditionally exports all the
Winsock error constants defined in your system F<WinError.h> include
file. These are included in a second export tag, C<:WINSOCK>.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a
non-zero value only if C<$!> is set to that value. For example:

    my $fh;
    unless (open($fh, "<", "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

If a specified constant C<EFOO> does not exist on the system, C<$!{EFOO}>
returns C<"">.  You may use C<exists $!{EFOO}> to check whether the
constant is available on the system.

Perl automatically loads C<Errno> the first time you use C<%!>, so you don't
need an explicit C<use>.

=head1 CAVEATS

Importing a particular constant may not be very portable, because the
import will fail on platforms that do not have that constant.  A more
portable way to set C<$!> to a valid value is to use:

    if (exists &Errno::EFOO) {
        $! = &Errno::EFOO;
    }

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

# ex: set ro:
